/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.class_loading.Boot;
import dev.kostromdan.mods.crash_assistant.app.gui.AnimatedBorder;
import dev.kostromdan.mods.crash_assistant.app.gui.ControlPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.FileListPanel;
import dev.kostromdan.mods.crash_assistant.app.gui.IncompatibleModsWarning;
import dev.kostromdan.mods.crash_assistant.app.gui.IntelChipBugWarning;
import dev.kostromdan.mods.crash_assistant.app.gui.PrivacyPolicyDialog;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.CorruptedConfigFinderGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.CorruptedJarFinderGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.MCreatorModDetectorGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.PackageFinderGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.CreateDependenciesAnalysisGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.EpicFightDependenciesAnalysisGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies.JdepsDependenciesAnalysisGUI;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReason;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.KnownCrashReasonMessage;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.Log;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogAnalyser;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogType;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.LogsList;
import dev.kostromdan.mods.crash_assistant.app.logs_analyser.RendererParser;
import dev.kostromdan.mods.crash_assistant.app.utils.DragAndDrop;
import dev.kostromdan.mods.crash_assistant.app.utils.TerminatedProcessesFinder;
import dev.kostromdan.mods.crash_assistant.common_config.communication.ProcessSignalIO;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantConfig;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.Lang;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.IncompatibleMod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListDiff;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.ProcessHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class CrashAssistantGUI {
    private static JFrame frame = null;
    public static FileListPanel fileListPanel = null;
    private static ControlPanel controlPanel;
    private static JPanel labelPanel;
    private static final Map<JComponent, OriginalState> highlightedComponents;

    private static BufferedImage loadModpackLogo(String path) {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        Path logoPath = Paths.get(path, new String[0]);
        if (!Files.exists(logoPath, new LinkOption[0]) || !Files.isRegularFile(logoPath, new LinkOption[0])) {
            CrashAssistantApp.LOGGER.error("Modpack logo not found or is not a file: {}", (Object)logoPath.toAbsolutePath());
            return null;
        }
        try {
            return ImageIO.read(logoPath.toFile());
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.error("Failed to load modpack logo from path: {}", (Object)logoPath.toAbsolutePath(), (Object)e);
            return null;
        }
    }

    private static ImageIcon resizeLogo(BufferedImage originalImage, int maxWidth, int maxHeight) {
        if (originalImage == null) {
            return null;
        }
        int originalWidth = originalImage.getWidth();
        int originalHeight = originalImage.getHeight();
        if (originalWidth <= 0 || originalHeight <= 0) {
            return new ImageIcon(originalImage);
        }
        double ratio = Math.min((double)maxWidth / (double)originalWidth, (double)maxHeight / (double)originalHeight);
        int newWidth = (int)((double)originalWidth * ratio);
        int newHeight = (int)((double)originalHeight * ratio);
        if (newWidth <= 0 || newHeight <= 0) {
            return new ImageIcon(originalImage);
        }
        Image resizedImage = originalImage.getScaledInstance(newWidth, newHeight, 4);
        return new ImageIcon(resizedImage);
    }

    private static boolean isGifPath(String path) {
        if (path == null) {
            return false;
        }
        String lower = path.trim().toLowerCase(Locale.ROOT);
        return lower.endsWith(".gif");
    }

    private static ImageIcon loadAnimatedGifIcon(String path) {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        Path logoPath = Paths.get(path, new String[0]);
        if (!Files.exists(logoPath, new LinkOption[0]) || !Files.isRegularFile(logoPath, new LinkOption[0])) {
            CrashAssistantApp.LOGGER.error("Modpack logo not found or is not a file: {}", (Object)logoPath.toAbsolutePath());
            return null;
        }
        try {
            return new ImageIcon(logoPath.toAbsolutePath().toString());
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Failed to load animated GIF modpack logo from path: {}", (Object)logoPath.toAbsolutePath(), (Object)e);
            return null;
        }
    }

    public CrashAssistantGUI() {
        LanguageProvider.updateLang();
        frame = new JFrame(LanguageProvider.get((String)"gui.window_name"));
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                CrashAssistantApp.LOGGER.info("Crash Assistant closed.");
                System.exit(0);
            }
        });
        frame.setSize(500, 400);
        frame.setLayout(new BorderLayout());
        CrashAssistantGUI.setUpIcon(frame);
        CrashAssistantGUI.addFileMenu();
        String logoPath = (String)CrashAssistantConfig.get((String)"gui_customisation.modpack_logo_path");
        boolean largeLogoMode = CrashAssistantConfig.getBoolean((String)"gui_customisation.modpack_logo_large_mode");
        int modpackLogoHeightLimit = CrashAssistantConfig.getInteger((String)"gui_customisation.limit_modpack_logo_height");
        boolean isGif = CrashAssistantGUI.isGifPath(logoPath);
        BufferedImage logoImage = isGif ? null : CrashAssistantGUI.loadModpackLogo(logoPath);
        ImageIcon animatedLogoIcon = isGif ? CrashAssistantGUI.loadAnimatedGifIcon(logoPath) : null;
        boolean showScreenshotNotice = CrashAssistantConfig.getBoolean((String)"gui_customisation.show_dont_send_screenshot_of_gui_notice");
        String titleText = CrashAssistantGUI.getTitleCrashedText(false);
        JLabel titleLabel = new JLabel(titleText, 2);
        titleLabel.setAlignmentX(0.0f);
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        HashMap<String, String> hrefOptions = new HashMap<String, String>(){
            {
                this.put("$CONFIG.text.support_name$", null);
                this.put("$LANG.gui.upload_all_comment$", null);
            }
        };
        String firstLinesOfComment = PlatformHelp.isLinkDefault() ? LanguageProvider.get((String)"gui.comment_under_title_cant_resolve", (HashMap)hrefOptions) : LanguageProvider.get((String)"gui.comment_under_title_pls_report", (HashMap)hrefOptions);
        String commentText = "<div style='margin-left: 5px;'>" + firstLinesOfComment + "\n" + LanguageProvider.get((String)"gui.comment_under_title", (HashMap)hrefOptions) + "</div>";
        JEditorPane commentPane = CrashAssistantGUI.getEditorPaneNoMargins(commentText, false);
        String screenshotNoticeText = LanguageProvider.get((String)"gui.comment_under_title_screenshot_notice");
        String screenshotHtml = "<span style='color:red;'><b>" + screenshotNoticeText + "</b></span>";
        JEditorPane screenshotNoticePane = CrashAssistantGUI.getEditorPaneNoMargins(screenshotHtml, false);
        if (showScreenshotNotice && CrashAssistantConfig.getBoolean((String)"gui_customisation.screenshot_of_gui_notice_animated_border")) {
            screenshotNoticePane.setBorder(new AnimatedBorder(screenshotNoticePane, Color.RED, false));
        }
        labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 3, 5));
        JPanel mainTextPanel = new JPanel();
        mainTextPanel.setLayout(new BoxLayout(mainTextPanel, 1));
        mainTextPanel.setOpaque(false);
        mainTextPanel.add(titleLabel);
        if (!commentText.isEmpty()) {
            mainTextPanel.add(commentPane);
        }
        JLabel modpackLogoLabel = new JLabel();
        if (logoImage == null && animatedLogoIcon == null) {
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            contentPanel.add(mainTextPanel);
            if (showScreenshotNotice) {
                contentPanel.add(Box.createVerticalStrut(3));
                contentPanel.add(screenshotNoticePane);
            }
            labelPanel.add((Component)contentPanel, "Center");
        } else if (largeLogoMode) {
            JPanel leftColumn = new JPanel();
            leftColumn.setOpaque(false);
            leftColumn.setLayout(new BoxLayout(leftColumn, 1));
            leftColumn.add(mainTextPanel);
            if (showScreenshotNotice) {
                leftColumn.add(Box.createVerticalStrut(3));
                leftColumn.add(screenshotNoticePane);
            }
            labelPanel.add((Component)leftColumn, "Center");
            textHeight = leftColumn.getPreferredSize().height;
            maxW = 500;
            int n = maxH = modpackLogoHeightLimit != -1 ? Math.min(modpackLogoHeightLimit, textHeight) : textHeight;
            if (animatedLogoIcon != null) {
                modpackLogoLabel.setIcon(new ScaledImageIcon(animatedLogoIcon, maxW, maxH));
            } else {
                modpackLogoLabel.setIcon(CrashAssistantGUI.resizeLogo(logoImage, maxW, maxH));
            }
            modpackLogoLabel.setVerticalAlignment(0);
            modpackLogoLabel.setHorizontalAlignment(0);
            logoWrapper = new JPanel();
            logoWrapper.setLayout(new BoxLayout(logoWrapper, 1));
            logoWrapper.setOpaque(false);
            logoWrapper.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
            logoWrapper.add(Box.createVerticalGlue());
            logoWrapper.add(modpackLogoLabel);
            logoWrapper.add(Box.createVerticalGlue());
            JPanel logoContainer = new JPanel(new BorderLayout());
            logoContainer.setOpaque(false);
            logoContainer.add((Component)logoWrapper, CrashAssistantConfig.getBoolean((String)"gui_customisation.modpack_logo_aligned_center") ? "Center" : "North");
            labelPanel.add((Component)logoContainer, "East");
        } else {
            JPanel topRowPanel = new JPanel(new BorderLayout(5, 0));
            topRowPanel.add((Component)mainTextPanel, "Center");
            textHeight = mainTextPanel.getPreferredSize().height;
            maxW = 500;
            int n = maxH = modpackLogoHeightLimit != -1 ? Math.min(modpackLogoHeightLimit, textHeight - 3) : textHeight - 3;
            if (animatedLogoIcon != null) {
                modpackLogoLabel.setIcon(new ScaledImageIcon(animatedLogoIcon, maxW, maxH));
            } else {
                modpackLogoLabel.setIcon(CrashAssistantGUI.resizeLogo(logoImage, maxW, maxH));
            }
            logoWrapper = new JPanel(new GridBagLayout());
            logoWrapper.setOpaque(false);
            GridBagConstraints logoGbc = new GridBagConstraints();
            logoGbc.anchor = 10;
            logoWrapper.add((Component)modpackLogoLabel, logoGbc);
            JPanel logoContainer = new JPanel(new BorderLayout());
            logoContainer.setOpaque(false);
            boolean centerAligned = CrashAssistantConfig.getBoolean((String)"gui_customisation.modpack_logo_aligned_center");
            logoContainer.add((Component)logoWrapper, centerAligned ? "Center" : "North");
            logoContainer.setBorder(BorderFactory.createEmptyBorder(centerAligned ? 0 : 1, 0, 0, 0));
            topRowPanel.add((Component)logoContainer, "East");
            JPanel contentPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            contentPanel.add((Component)topRowPanel, gbc);
            if (showScreenshotNotice) {
                gbc.gridy = 1;
                gbc.insets = new Insets(2, 0, 0, 0);
                contentPanel.add((Component)screenshotNoticePane, gbc);
            }
            labelPanel.add((Component)contentPanel, "Center");
        }
        frame.add((Component)labelPanel, "North");
        fileListPanel = new FileListPanel();
        frame.add((Component)fileListPanel.getScrollPane(), "Center");
        controlPanel = new ControlPanel(fileListPanel);
        frame.add((Component)controlPanel.getPanel(), "South");
        for (Log log : LogsList.getLogs()) {
            fileListPanel.addLog(log);
        }
        DragAndDrop.enableDragAndDrop(fileListPanel.getScrollPane(), CrashAssistantGUI.fileListPanel.fileListPanelFilesDragAndDrop);
        CrashAssistantGUI.resize();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        java.util.Timer timer = new java.util.Timer();
        timer.schedule(new TimerTask(this){
            final long startTime = Instant.now().toEpochMilli();

            @Override
            public void run() {
                if (!ControlPanel.stopMovingToTop) {
                    SwingUtilities.invokeLater(() -> {
                        frame.setAlwaysOnTop(true);
                        frame.toFront();
                        frame.setAlwaysOnTop(false);
                    });
                }
                if (Instant.now().toEpochMilli() - this.startTime > 5000L) {
                    this.cancel();
                }
            }
        }, 0L, 50L);
        CrashAssistantApp.GUIStartTime = Instant.now().toEpochMilli() - CrashAssistantApp.GUIStartTime;
        CrashAssistantApp.GUIInitialisationFinished = true;
        CrashAssistantApp.LOGGER.info("CrashAssistantGUI took to start: " + (float)CrashAssistantApp.GUIStartTime / 1000.0f + " seconds.");
        controlPanel.updateModListInfo();
        CrashAssistantGUI.showCrashAssistantDuplicatedWarning();
        CrashAssistantGUI.showIncompatibleModsWarning();
        IncompatibleModsWarning.showWarnings(frame);
        CrashAssistantGUI.showTooManyChangesWarning();
        IntelChipBugWarning.showIfAffected(false);
        CrashAssistantGUI.showEarlyIntegratedGPUWarning();
        new Thread(() -> {
            LogAnalyser.analyseLogs();
            CrashAssistantGUI.showKnownCrashReasonsWarnings();
        }).start();
    }

    public static void setUpIcon(JFrame frame) {
        try {
            InputStream iconStream = JarInJarHelper.class.getResourceAsStream("/crash_assistant_ico.png");
            if (iconStream != null) {
                BufferedImage iconImage = ImageIO.read(iconStream);
                frame.setIconImage(iconImage);
                iconStream.close();
            } else {
                CrashAssistantApp.LOGGER.warn("Could not find crash_assistant_logo.png in jar root");
            }
        }
        catch (IOException e) {
            CrashAssistantApp.LOGGER.error("Failed to load window icon", (Throwable)e);
        }
    }

    private static void addFileMenu() {
        BiFunction<String, String, JMenuItem> makeMenuItem = (titleKey, descKey) -> {
            String title = LanguageProvider.get((String)titleKey);
            String desc = LanguageProvider.get((String)descKey);
            Function<String, String> esc = s -> s == null ? "" : s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>");
            String html = "<html><b>" + esc.apply(title) + "</b><br><span style='color:gray; font-size:10px;'>" + esc.apply(desc) + "</span></html>";
            return new JMenuItem(html);
        };
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(LanguageProvider.get((String)"gui.menu.file"));
        JMenu privacyMenu = new JMenu(LanguageProvider.get((String)"gui.menu.privacy"));
        JMenuItem openModsFolderItem = new JMenuItem(LanguageProvider.get((String)"gui.menu.file.open_mods_folder"));
        openModsFolderItem.addActionListener(e -> {
            try {
                File modsFolder = new File("mods");
                Desktop.getDesktop().open(modsFolder);
            }
            catch (IOException ex) {
                CrashAssistantApp.LOGGER.error("Error opening mods folder", (Throwable)ex);
            }
        });
        fileMenu.add(openModsFolderItem);
        JMenuItem openConfigFolderItem = new JMenuItem(LanguageProvider.get((String)"gui.menu.file.open_config_folder"));
        openConfigFolderItem.addActionListener(e -> {
            try {
                File configFolder = new File("config");
                Desktop.getDesktop().open(configFolder);
            }
            catch (IOException ex) {
                CrashAssistantApp.LOGGER.error("Error opening config folder", (Throwable)ex);
            }
        });
        fileMenu.add(openConfigFolderItem);
        JMenuItem openModpackFolderItem = new JMenuItem(LanguageProvider.get((String)"gui.menu.file.open_modpack_folder"));
        openModpackFolderItem.addActionListener(e -> {
            try {
                File modpackFolder = new File(".");
                Desktop.getDesktop().open(modpackFolder);
            }
            catch (IOException ex) {
                CrashAssistantApp.LOGGER.error("Error opening modpack folder", (Throwable)ex);
            }
        });
        fileMenu.add(openModpackFolderItem);
        JMenuItem openConfigItem = new JMenuItem(LanguageProvider.get((String)"gui.menu.file.open_config"));
        openConfigItem.addActionListener(e -> {
            try {
                File configFile = new File("config/crash_assistant/config.toml");
                Desktop.getDesktop().open(configFile);
            }
            catch (IOException ex) {
                CrashAssistantApp.LOGGER.error("Error opening config file", (Throwable)ex);
            }
        });
        fileMenu.add(openConfigItem);
        boolean analysisMenuEnabled = CrashAssistantConfig.getBoolean((String)"analysis_tools.enabled");
        JMenu analysisMenu = new JMenu(LanguageProvider.get((String)"gui.menu.analysis"));
        if (analysisMenuEnabled) {
            ArrayList disabledByConfigTools = CrashAssistantConfig.getBlacklistedAnalysisTools();
            if (!disabledByConfigTools.contains("CreateDependenciesAnalysisGUI")) {
                JMenuItem createAnalysisItem = makeMenuItem.apply("gui.menu.analysis.create_dependencies", "gui.menu.analysis.create_dependencies.desc");
                createAnalysisItem.addActionListener(e -> CreateDependenciesAnalysisGUI.showCreateAnalysisDialog(frame));
                analysisMenu.add(createAnalysisItem);
            }
            if (!disabledByConfigTools.contains("EpicFightDependenciesAnalysisGUI")) {
                JMenuItem epicFightAnalysisItem = makeMenuItem.apply("gui.menu.analysis.epic_fight_addons_compatibility", "gui.menu.analysis.epic_fight_addons_compatibility.desc");
                epicFightAnalysisItem.addActionListener(e -> EpicFightDependenciesAnalysisGUI.showEpicFightAnalysisDialog(frame));
                analysisMenu.add(epicFightAnalysisItem);
            }
            if (!disabledByConfigTools.contains("MCreatorModDetectorGUI")) {
                JMenuItem mcreatorDetectorItem = makeMenuItem.apply("gui.menu.analysis.mcreator_mod_detector", "gui.analysis.mcreator_detector.header");
                mcreatorDetectorItem.addActionListener(e -> MCreatorModDetectorGUI.showMCreatorModDetectorDialog(frame));
                analysisMenu.add(mcreatorDetectorItem);
            }
            if (!disabledByConfigTools.contains("PackageFinderGUI")) {
                JMenuItem packageFinderItem = makeMenuItem.apply("gui.menu.analysis.package_class_finder", "gui.analysis.package_finder.header");
                packageFinderItem.addActionListener(e -> PackageFinderGUI.showPackageFinderDialog(frame));
                analysisMenu.add(packageFinderItem);
            }
            if (!disabledByConfigTools.contains("JdepsDependenciesAnalysisGUI")) {
                JMenuItem jdepsAnalysisItem = makeMenuItem.apply("gui.menu.analysis.jdeps_dependencies_analysis", "gui.analysis.jdeps.header");
                jdepsAnalysisItem.addActionListener(e -> JdepsDependenciesAnalysisGUI.showDialog(frame));
                analysisMenu.add(jdepsAnalysisItem);
            }
            if (!disabledByConfigTools.contains("CorruptedJarFinderGUI")) {
                JMenuItem corruptedJarFinderItem = makeMenuItem.apply("gui.menu.analysis.corrupted_jar_finder", "gui.menu.analysis.corrupted_jar_finder.desc");
                corruptedJarFinderItem.addActionListener(e -> CorruptedJarFinderGUI.showDialog(frame));
                analysisMenu.add(corruptedJarFinderItem);
            }
            if (!disabledByConfigTools.contains("CorruptedConfigFinderGUI")) {
                JMenuItem corruptedConfigFinderItem = makeMenuItem.apply("gui.menu.analysis.corrupted_config_finder", "gui.menu.analysis.corrupted_config_finder.desc");
                corruptedConfigFinderItem.addActionListener(e -> CorruptedConfigFinderGUI.showDialog(frame));
                analysisMenu.add(corruptedConfigFinderItem);
            }
        }
        JMenuItem logsPrivacyItem = new JMenuItem(LanguageProvider.get((String)"gui.menu.privacy.logs_info"));
        logsPrivacyItem.addActionListener(e -> CrashAssistantGUI.showLogsPrivacyInfo());
        privacyMenu.add(logsPrivacyItem);
        JMenuItem resetConsentItem = new JMenuItem(LanguageProvider.get((String)"gui.menu.privacy.reset_consent"));
        resetConsentItem.addActionListener(e -> PrivacyPolicyDialog.resetPrivacyConsent());
        privacyMenu.add(resetConsentItem);
        menuBar.add(fileMenu);
        if (analysisMenuEnabled) {
            menuBar.add(analysisMenu);
        }
        menuBar.add(privacyMenu);
        frame.setJMenuBar(menuBar);
    }

    private static void showLogsPrivacyInfo() {
        String privacyInfo = Lang.applyPlaceHolders((String)"<h2>$LANG.gui.privacy.crash_assistant_privacy_policy.version_text$ $LANG.gui.privacy.crash_assistant_privacy_policy.version$</h2>$LANG.gui.privacy.crash_assistant_privacy_policy.crash_assistant$ $LANG.gui.privacy.crash_assistant_privacy_policy.mclogs$ $LANG.gui.privacy.crash_assistant_privacy_policy.gnomebot$ $LANG.gui.privacy.crash_assistant_privacy_policy.validity$ $LANG.gui.privacy.crash_assistant_privacy_policy.reset$ $LANG.gui.privacy.crash_assistant_privacy_policy.volume$", (HashMap)new HashMap<String, String>(){
            {
                this.put("$LINK.MCLOGS_PRIVACY_POLICY$", LanguageProvider.get((String)"gui.privacy.privacy_policy"));
                this.put("$LINK.CRASH_ASSISTANT$", LanguageProvider.get((String)"gui.privacy.mod_description"));
                this.put("$LINK.CRASH_ASSISTANT_DISCORD$", "discord");
                this.put("$LINK.LAT_DISCORD$", "discord");
            }
        });
        privacyInfo = privacyInfo.replace("$GNOMEBOT_ENABLED$", Objects.toString(CrashAssistantGUI.isUploadingToGnome()));
        JEditorPane editorPane = CrashAssistantGUI.getEditorPane(privacyInfo, true, 600);
        JScrollPane scrollPane = new JScrollPane(editorPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(editorPane.getPreferredSize().width, 500));
        SwingUtilities.invokeLater(() -> scrollPane.getVerticalScrollBar().setValue(0));
        JOptionPane optionPane = new JOptionPane(scrollPane, 1, -1);
        JDialog dialog = optionPane.createDialog(frame, LanguageProvider.get((String)"gui.privacy.title"));
        dialog.setVisible(true);
    }

    public static void resize() {
        if (frame == null || fileListPanel == null) {
            return;
        }
        int old = fileListPanel.getScrollPane().getVerticalScrollBarPolicy();
        fileListPanel.getScrollPane().setVerticalScrollBarPolicy(22);
        frame.pack();
        frame.setSize(CrashAssistantGUI.frame.getPreferredSize().width, Math.min(CrashAssistantGUI.frame.getPreferredSize().height, 700));
        frame.setMinimumSize(new Dimension(CrashAssistantGUI.frame.getSize().width, CrashAssistantGUI.frame.getSize().height));
        fileListPanel.getScrollPane().setVerticalScrollBarPolicy(old);
        frame.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void showKnownCrashReasonsWarnings() {
        ControlPanel.stopMovingToTop = true;
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    for (KnownCrashReasonMessage crashReasonMessage : KnownCrashReasonMessage.getAllMessages()) {
                        JDialog dialog;
                        KnownCrashReason crashReason;
                        if (crashReasonMessage.isShownWarn() || KnownCrashReason.shownKnownCrashReasons.contains(crashReason = crashReasonMessage.getReason())) continue;
                        HashSet<String> conflictingReasons = crashReason.getConflictingReasons();
                        if (!conflictingReasons.isEmpty() && KnownCrashReason.shownKnownCrashReasons.stream().anyMatch(x -> conflictingReasons.contains(x.getClass().getSimpleName()))) {
                            CrashAssistantApp.LOGGER.info("Skipping KnownCrashReason: {}", (Object)crashReason.getClass().getSimpleName());
                            continue;
                        }
                        KnownCrashReason.shownKnownCrashReasons.add(crashReason);
                        CrashAssistantApp.LOGGER.info("Showing KnownCrashReason: {}\n{}", (Object)crashReason.getClass().getSimpleName(), crashReasonMessage.isCodexMessage() ? crashReasonMessage.getMessage() : crashReasonMessage.getMessage().split("\n")[0] + "...");
                        crashReasonMessage.setShownWarn(true);
                        JEditorPane messagePane = CrashAssistantGUI.getEditorPane(crashReasonMessage.getMessage(), crashReasonMessage.isCodexMessage());
                        LinkedHashMap<String, Consumer<JDialog>> autoFixButtons = crashReason.getAutoFixButtons();
                        if (!autoFixButtons.isEmpty()) {
                            JPanel autoFixPanel = new JPanel(new GridBagLayout());
                            GridBagConstraints gbc = new GridBagConstraints();
                            gbc.fill = 2;
                            gbc.weightx = 1.0;
                            gbc.gridy = 0;
                            ArrayList<JButton> buttons = new ArrayList<JButton>();
                            ArrayList<Consumer<JDialog>> actions = new ArrayList<Consumer<JDialog>>();
                            for (Map.Entry<String, Consumer<JDialog>> entry : autoFixButtons.entrySet()) {
                                JButton autoFixButton = new JButton(entry.getKey());
                                autoFixButton.setFont(autoFixButton.getFont().deriveFont(1, CrashAssistantConfig.getInteger((String)"gui_customisation.auto_fix_button_font_size")));
                                autoFixButton.setForeground(ControlPanel.deserializeColor((String)CrashAssistantConfig.get((String)"gui_customisation.auto_fix_button_foreground_color"), autoFixButton.getForeground()));
                                autoFixPanel.add((Component)autoFixButton, gbc);
                                ++gbc.gridy;
                                buttons.add(autoFixButton);
                                actions.add(entry.getValue());
                            }
                            JPanel mainPanel = new JPanel(new BorderLayout(10, 5));
                            mainPanel.add((Component)messagePane, "Center");
                            mainPanel.add((Component)autoFixPanel, "South");
                            JOptionPane optionPane = new JOptionPane(mainPanel, 2, -1);
                            dialog = optionPane.createDialog(frame, crashReasonMessage.isCodexMessage() ? LanguageProvider.get((String)"gui.codex_logs_analyzer") : LanguageProvider.get((String)"gui.logs_analyzer"));
                            for (int i = 0; i < buttons.size(); ++i) {
                                JButton button = (JButton)buttons.get(i);
                                Consumer action = (Consumer)actions.get(i);
                                JDialog finalDialog = dialog;
                                button.addActionListener(e -> action.accept(finalDialog));
                            }
                        } else {
                            JOptionPane optionPane = new JOptionPane(messagePane, 2, -1);
                            dialog = optionPane.createDialog(frame, crashReasonMessage.isCodexMessage() ? LanguageProvider.get((String)"gui.codex_logs_analyzer") : LanguageProvider.get((String)"gui.logs_analyzer"));
                        }
                        long showStartTime = System.currentTimeMillis();
                        dialog.setVisible(true);
                        CrashAssistantApp.LOGGER.info("Shown KnownCrashReason: {} (Seen warning for {}s)", (Object)crashReason.getClass().getSimpleName(), (Object)((double)(System.currentTimeMillis() - showStartTime) / 1000.0));
                    }
                });
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while showing known crash reasons warnings: ", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showCrashAssistantDuplicatedWarning() {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            try {
                if (PlatformHelp.platform != PlatformHelp.FORGE && PlatformHelp.platform != PlatformHelp.NEOFORGE) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                List mods = JarInJarHelper.checkDuplicatedCrashAssistantMod((boolean)false);
                if (mods.size() < 2) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                ControlPanel.stopMovingToTop = true;
                SwingUtilities.invokeAndWait(() -> {
                    JOptionPane optionPane = new JOptionPane(CrashAssistantGUI.getEditorPane(LanguageProvider.get((String)"gui.duplicated_mod_warn").replace("$MODS$", String.join((CharSequence)"\n", mods.stream().map(Mod::getJarName).collect(Collectors.toList()))), false), 2, -1);
                    JDialog dialog = optionPane.createDialog(frame, LanguageProvider.get((String)"gui.duplicated_mod"));
                    dialog.setVisible(true);
                });
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while showing crash assistant duplicated warning: ", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showTooManyChangesWarning() {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            try {
                try {
                    if (Objects.equals(CrashAssistantLocalConfig.get((String)"too_many_changes.dont_show_again"), true)) {
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int allowedChanges = CrashAssistantConfig.getInteger((String)"too_many_changes_warning.count");
                if (allowedChanges <= 0) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (ModListDiff.isModpackCreator()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                int totalChanges = ModListDiff.getDiff((boolean)true).getTotalChanges();
                if (totalChanges <= allowedChanges) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                String message = CrashAssistantConfig.get((String)"too_many_changes_warning.formulation_type").equals("DROP_SUPPORT") ? LanguageProvider.get((String)"gui.too_many_changes_warning_drop_support") : LanguageProvider.get((String)"gui.too_many_changes_warning_notice");
                message = message.replace("$MODIFICATIONS_COUNT$", "<strong style='color: red;'>" + totalChanges + "</strong>");
                ControlPanel.stopMovingToTop = true;
                String finalMessage = message;
                SwingUtilities.invokeAndWait(() -> {
                    JDialog dialog = new JDialog((Frame)null, LanguageProvider.get((String)"gui.too_many_changes_title"), true);
                    dialog.setDefaultCloseOperation(2);
                    JEditorPane textPane = CrashAssistantGUI.getEditorPane(finalMessage, false);
                    JPanel textPanel = new JPanel(new BorderLayout());
                    textPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
                    textPanel.add((Component)textPane, "Center");
                    JCheckBox dontShowAgainCheck = new JCheckBox(LanguageProvider.get((String)"gui.intel_corrupted_dont_show_again"));
                    dontShowAgainCheck.addActionListener(e -> CrashAssistantLocalConfig.set((String)"too_many_changes.dont_show_again", (Object)dontShowAgainCheck.isSelected()));
                    JButton okButton = new JButton("OK");
                    okButton.addActionListener(e -> dialog.dispose());
                    JPanel bottomPanel = new JPanel(new FlowLayout(1, 10, 5));
                    bottomPanel.add(dontShowAgainCheck);
                    bottomPanel.add(okButton);
                    JPanel mainPanel = new JPanel(new BorderLayout(10, 5));
                    mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    mainPanel.add((Component)textPanel, "Center");
                    mainPanel.add((Component)bottomPanel, "South");
                    dialog.setContentPane(mainPanel);
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                    CrashAssistantApp.LOGGER.info("Showing too many changes warning");
                    dialog.setVisible(true);
                    CrashAssistantApp.LOGGER.info("Too many changes warning dialog closed");
                });
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while showing too many changes warning: ", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showEarlyIntegratedGPUWarning() {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            try {
                if (Boot.serialisedGPUs == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (CrashAssistantApp.renderer != null && !Objects.equals(CrashAssistantApp.renderer, "UNDEFINED")) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                Log latest = null;
                for (Log log : LogsList.getLogs()) {
                    if (log.getType() != LogType.LOG) continue;
                    latest = log;
                    break;
                }
                if (latest == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                latest.getReader().readLogFileSafe();
                List<String> firstLines = latest.getReader().getFirstLinesList();
                String renderer = null;
                for (int i = 0; i < Math.min(firstLines.size(), 1000) && (renderer = RendererParser.getRenderer(firstLines.get(i))) == null; ++i) {
                }
                if (renderer == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (Objects.equals(CrashAssistantApp.renderer, "UNDEFINED")) {
                    CrashAssistantApp.renderer = null;
                }
                ProcessSignalIO.postAsOtherProcess((String)"renderer", (String)renderer, (long)Boot.parentPID);
                CrashAssistantApp.LOGGER.info("Minecraft process have not reached out our renderer parsing hook, but successfully parsed renderer from logs: {}", (Object)renderer);
                CrashAssistantApp.checkRendererFile();
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while showing early IGPU warning: ", (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showIncompatibleModsWarning() {
        Class<KnownCrashReasonMessage> clazz = KnownCrashReasonMessage.class;
        synchronized (KnownCrashReasonMessage.class) {
            try {
                Optional incompatibleMod = JarInJarHelper.checkForIncompatibleMods((boolean)false);
                if (!incompatibleMod.isPresent()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                List detectedMods = ((IncompatibleMod)incompatibleMod.get()).getDetectedMods();
                if (detectedMods.isEmpty()) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                if (!CrashAssistantConfig.getBoolean((String)"compatibility.enabled")) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                ControlPanel.stopMovingToTop = true;
                SwingUtilities.invokeAndWait(() -> {
                    JButton removeIncompatibleButton = new JButton("Close " + ((Mod)detectedMods.get(0)).getModId() + " and remove.");
                    JButton removeCrashAssistantButton = new JButton("Close crash_assistant and remove.");
                    Object[] options = new Object[]{removeIncompatibleButton, removeCrashAssistantButton, "Close"};
                    JOptionPane optionPane = new JOptionPane(CrashAssistantGUI.getEditorPane("<h2>Warning: incompatible mod(s) detected!</h2>\n<strong>" + Boot.crashAssistantModJarName + "</strong> and <strong>" + String.join((CharSequence)", ", detectedMods.stream().map(Mod::getJarName).collect(Collectors.toList())) + " </strong>are incompatible.\nYou should remove one them!<h4><strong>Why did Crash Assistant mark this mod as incompatible?</strong></h4>" + ((IncompatibleMod)incompatibleMod.get()).getExplainMessage(), true, 600), 2, -1, null, options, options[0]);
                    JDialog dialog = optionPane.createDialog(frame, "Incompatible Mods Detected");
                    dialog.setAlwaysOnTop(true);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            CrashAssistantApp.LOGGER.info("Incompatible mods dialog closed with window close button. Exiting with code 0.");
                            System.exit(0);
                        }
                    });
                    removeIncompatibleButton.addActionListener(e -> {
                        try {
                            dialog.setAlwaysOnTop(false);
                            boolean allDeleted = true;
                            Iterator iterator = detectedMods.iterator();
                            while (iterator.hasNext()) {
                                File modsDir = new File("mods");
                                Mod mod = (Mod)iterator.next();
                                String jarName = mod.getJarName();
                                File modFile = new File(modsDir, jarName);
                                if (modFile.exists()) {
                                    String[] childProcessesData;
                                    if (modFile.delete()) {
                                        CrashAssistantApp.LOGGER.info("Successfully deleted incompatible mod: {}", (Object)jarName);
                                        continue;
                                    }
                                    boolean destroyAttemptSuccess = false;
                                    if (!Objects.equals(PlatformHelp.childProcessesPIDs, "UNDEFINED") && (childProcessesData = PlatformHelp.childProcessesPIDs.split("\\n")).length == 1) {
                                        long childProcessPID = Long.parseLong(childProcessesData[0].split(": ")[0]);
                                        long childProcessStart = Long.parseLong(childProcessesData[0].split(": ")[1]);
                                        if (ProcessHelper.isProcessAlive((long)childProcessPID) && ProcessHelper.getProcessStartTime((long)childProcessPID) == childProcessStart) {
                                            ProcessHelper.destroyProcessForcibly((long)childProcessPID);
                                            long startDeleteTime = System.currentTimeMillis();
                                            while (System.currentTimeMillis() - startDeleteTime < 5000L) {
                                                if (modFile.delete()) {
                                                    CrashAssistantApp.LOGGER.info("Successfully deleted incompatible mod after retry: {}", (Object)jarName);
                                                    destroyAttemptSuccess = true;
                                                    break;
                                                }
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (InterruptedException interruptedException) {}
                                            }
                                        }
                                    }
                                    if (destroyAttemptSuccess) continue;
                                    CrashAssistantApp.LOGGER.error("Failed to delete incompatible mod: {}", (Object)jarName);
                                    allDeleted = false;
                                    continue;
                                }
                                CrashAssistantApp.LOGGER.error("Could not find incompatible mod file: {}", (Object)jarName);
                                allDeleted = false;
                            }
                            if (allDeleted) {
                                JOptionPane.showMessageDialog(frame, CrashAssistantGUI.getEditorPane("Incompatible mods have been removed. Please restart your game.", false), "Incompatible Mods Removed", 1);
                                CrashAssistantApp.LOGGER.info("All incompatible mods deleted successfully. Exiting with code 0.");
                                System.exit(0);
                            } else {
                                JOptionPane.showMessageDialog(frame, CrashAssistantGUI.getEditorPane("Some incompatible mods could not be removed. Please delete them manually from your mods folder.", false), "Warning", 2);
                            }
                        }
                        catch (Exception ex) {
                            CrashAssistantApp.LOGGER.error("Error while removing incompatible mod: ", (Throwable)ex);
                            JOptionPane.showMessageDialog(frame, CrashAssistantGUI.getEditorPane("Failed to remove incompatible mod: " + ex.getMessage(), false), "Error", 0);
                        }
                    });
                    removeCrashAssistantButton.addActionListener(e -> {
                        try {
                            dialog.setAlwaysOnTop(false);
                            String jarName = Boot.crashAssistantModJarName;
                            File modsDir = new File("mods");
                            File modFile = new File(modsDir, jarName);
                            if (!modFile.exists()) {
                                CrashAssistantApp.LOGGER.error("Could not find Crash Assistant mod file: {}", (Object)jarName);
                                JOptionPane.showMessageDialog(frame, CrashAssistantGUI.getEditorPane("Could not find Crash Assistant mod file. It may have been moved or renamed.", false), "Warning", 2);
                                return;
                            }
                            Files.delete(modFile.toPath());
                            JOptionPane.showMessageDialog(frame, CrashAssistantGUI.getEditorPane("Crash Assistant has been successfully removed from:\n" + modFile.getPath() + "\n\nPlease restart your game.", false), "Success", 1);
                            System.exit(0);
                        }
                        catch (Exception ex) {
                            CrashAssistantApp.LOGGER.error("Error while removing Crash Assistant: ", (Throwable)ex);
                            JOptionPane.showMessageDialog(frame, CrashAssistantGUI.getEditorPane("Error while removing Crash Assistant: " + ex.getMessage(), false), "Error", 0);
                        }
                    });
                    frame.setVisible(false);
                    dialog.setVisible(true);
                    Class<TerminatedProcessesFinder> clazz = TerminatedProcessesFinder.class;
                    synchronized (TerminatedProcessesFinder.class) {
                        CrashAssistantApp.LOGGER.info("Incompatible mods dialog closed. Exiting with code 0.");
                        System.exit(0);
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        return;
                    }
                });
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.error("Error while showing incompatible mod warning: ", (Throwable)e);
            }
            return;
        }
    }

    public static void highlightButton(JComponent button, Color color, long time) {
        OriginalState state = highlightedComponents.computeIfAbsent(button, OriginalState::new);
        int currentGeneration = ++state.generation;
        Timer timer = new Timer(400, null);
        int[] count = new int[]{0};
        long startTime = Instant.now().toEpochMilli();
        String highlightStyle = "disabledBackground: " + String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        timer.addActionListener(e -> {
            if (state.generation != currentGeneration) {
                timer.stop();
                return;
            }
            if (Instant.now().toEpochMilli() - startTime > time) {
                timer.stop();
                button.setBackground(state.originalBackground);
                button.putClientProperty("FlatLaf.style", state.originalStyle);
                button.repaint();
                highlightedComponents.remove(button);
                return;
            }
            boolean isHighlightPhase = count[0] % 2 == 0;
            button.setBackground(isHighlightPhase ? color : state.originalBackground);
            button.putClientProperty("FlatLaf.style", isHighlightPhase ? highlightStyle : state.originalStyle);
            button.repaint();
            count[0] = count[0] + 1;
        });
        timer.start();
    }

    public static HyperlinkListener getHyperlinkListener() {
        return e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JComponent componentToHighlight;
                String description = e.getDescription();
                if ("LANG.gui.upload_all_comment".equals(description)) {
                    componentToHighlight = CrashAssistantGUI.controlPanel.uploadAllButton;
                } else if ("LANG.gui.file_list_label".equals(description)) {
                    componentToHighlight = fileListPanel.getScrollPane();
                    if (ControlPanel.dialog != null) {
                        ControlPanel.dialog.dispose();
                    }
                } else if ("CONFIG.text.support_name".equals(description)) {
                    componentToHighlight = CrashAssistantGUI.controlPanel.requestHelpButton;
                } else {
                    if ("PRIVACY_POLICY".equals(description)) {
                        CrashAssistantGUI.showLogsPrivacyInfo();
                        return;
                    }
                    if (e.getURL() != null) {
                        try {
                            ControlPanel.validateIsDomainTrustedAndOpenInBrowser(e.getURL().toString());
                        }
                        catch (Exception exception) {
                            CrashAssistantApp.LOGGER.error("Failed to open in link browser: ", (Throwable)exception);
                        }
                        return;
                    }
                    CrashAssistantApp.LOGGER.error("Unsupported hyperlink event: " + description);
                    return;
                }
                CrashAssistantGUI.highlightButton(componentToHighlight, new Color(100, 100, 255), 3000L);
            }
        };
    }

    public static JEditorPane getEditorPane(String text, boolean wrap) {
        return CrashAssistantGUI.getEditorPane(text, wrap, null);
    }

    public static JEditorPane getEditorPane(String text, boolean wrap, Integer width) {
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setContentType("text/html");
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        if (width != null) {
            html.append("<body style='width:" + width + "px;'>");
        }
        html.append("<div " + (wrap ? "" : "style='white-space:nowrap;'") + ">" + text.replaceAll("\n", "<br>") + "</div>");
        if (width != null) {
            html.append("</body>");
        }
        html.append("</html>");
        pane.setText(html.toString());
        Font defaultFont = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + defaultFont.getFamily() + "; font-size: " + defaultFont.getSize() + "pt; }";
        ((HTMLDocument)pane.getDocument()).getStyleSheet().addRule(bodyRule);
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.setBackground(new JButton().getBackground());
        pane.addHyperlinkListener(CrashAssistantGUI.getHyperlinkListener());
        pane.setAlignmentX(0.0f);
        return pane;
    }

    public static JEditorPane getEditorPaneNoMargins(String text, boolean wrap) {
        JEditorPane pane = CrashAssistantGUI.getEditorPane(text, wrap);
        pane.setMargin(new Insets(0, 0, 0, 0));
        pane.setBorder(BorderFactory.createEmptyBorder());
        String bodyRule = "body { margin: 0; padding: 0; }";
        ((HTMLDocument)pane.getDocument()).getStyleSheet().addRule(bodyRule);
        return pane;
    }

    public static boolean isUploadingToGnome() {
        return Objects.equals(CrashAssistantConfig.get((String)"general.upload_to"), "gnomebot.dev") || PlatformHelp.isLinkDefault();
    }

    public static String getUploadToLink() {
        return CrashAssistantGUI.isUploadingToGnome() ? "gnomebot.dev" : "mclo.gs";
    }

    public static String transformLink(String link) {
        if (CrashAssistantGUI.isUploadingToGnome()) {
            String id = ((String)link).substring(((String)link).lastIndexOf("/") + 1);
            link = "https://gnomebot.dev/paste/mclogs/" + id;
        }
        return link;
    }

    public static void updateLogsListInGUI() {
        SwingUtilities.invokeLater(CrashAssistantGUI::addMissingLogs);
        LogAnalyser.analyseLogs();
        CrashAssistantGUI.showKnownCrashReasonsWarnings();
    }

    public static void addMissingLogs() {
        for (Log log : LogsList.getLogs()) {
            if (!CrashAssistantGUI.fileListPanel.filePanelList.stream().noneMatch(x -> Objects.equals(x.getLog(), log))) continue;
            fileListPanel.addLog(log);
        }
        CrashAssistantGUI.resize();
    }

    public static String getTitleCrashedText(boolean forMsg) {
        Function langFunc = LanguageProvider.getLangFunction((boolean)forMsg);
        String oops = forMsg ? "" : "_oops";
        return CrashAssistantApp.crashed_with_report ? (String)langFunc.apply("gui.title_crashed_with_report" + oops) : (String)langFunc.apply("gui.title_crashed_without_report" + oops);
    }

    public static JFrame getFrame() {
        return frame;
    }

    static {
        highlightedComponents = new ConcurrentHashMap<JComponent, OriginalState>();
    }

    private static final class ScaledImageIcon
    extends ImageIcon {
        private final int maxWidth;
        private final int maxHeight;

        ScaledImageIcon(ImageIcon delegate, int maxWidth, int maxHeight) {
            super(delegate.getImage());
            this.maxWidth = Math.max(1, maxWidth);
            this.maxHeight = Math.max(1, maxHeight);
        }

        private Dimension getScaledSize() {
            int w = super.getIconWidth();
            int h = super.getIconHeight();
            if (w <= 0 || h <= 0) {
                return new Dimension(this.maxWidth, this.maxHeight);
            }
            double ratio = Math.min((double)this.maxWidth / (double)w, (double)this.maxHeight / (double)h);
            int newW = Math.max(1, (int)Math.round((double)w * ratio));
            int newH = Math.max(1, (int)Math.round((double)h * ratio));
            return new Dimension(newW, newH);
        }

        @Override
        public int getIconWidth() {
            return this.getScaledSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.getScaledSize().height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            Image image = this.getImage();
            if (image == null) {
                return;
            }
            Dimension d = this.getScaledSize();
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawImage(image, x, y, d.width, d.height, c);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private static class OriginalState {
        final Color originalBackground;
        final Object originalStyle;
        volatile int generation = 0;

        OriginalState(JComponent component) {
            this.originalBackground = component.getBackground();
            this.originalStyle = component.getClientProperty("FlatLaf.style");
        }
    }
}

